<?php

/**
 * This is the model class for table "DziedzinaUzytkownika".
 *
 * The followings are the available columns in table 'DziedzinaUzytkownika':
 * @property double $id
 * @property double $idUzytkownika
 * @property double $idDziedziny
 * @property double $punkty
 */
class DziedzinaUzytkownika extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return DziedzinaUzytkownika the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'DziedzinaUzytkownika';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('idUzytkownika, idDziedziny', 'required'),
			array('idUzytkownika, idDziedziny, punkty', 'numerical'),

			array('id, idUzytkownika, idDziedziny, punkty', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'idUzytkownika0'=>array(self::BELONGS_TO, 'Uzytkownik', 'idUzytkownika'),
			'idDziedziny0'=>array(self::BELONGS_TO, 'Dziedzina', 'idDziedziny'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'id'=>Yii::t('DziedzinaUzytkownika', 'id'),
			'idUzytkownika'=>Yii::t('DziedzinaUzytkownika', 'idUzytkownika'),
			'idDziedziny'=>Yii::t('DziedzinaUzytkownika', 'idDziedziny'),
			'punkty'=>Yii::t('DziedzinaUzytkownika', 'punkty'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('id', $this->id);
		$criteria->compare('idUzytkownika', $this->idUzytkownika);
		$criteria->compare('idDziedziny', $this->idDziedziny);
		$criteria->compare('punkty', $this->punkty);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	public static function add($studentId, $dziedzinaId, $points)
	{
		$record = self::model()->findByAttributes(array(
			'idUzytkownika' => $studentId,
			'idDziedziny' => $dziedzinaId
		));
		if (empty($record))
		{
			$record = new DziedzinaUzytkownika;
			$record->idDziedziny = $dziedzinaId;
			$record->idUzytkownika = $studentId;
		}
		$record->punkty = (float)$record->punkty + $points;
		$record->save(false);
	}
}